/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.CommandInvocation;
import com.quantumdata.sct.dao.jaxb.Service;
import com.quantumdata.sct.dao.jaxb.Services;
import com.quantumdata.sct.dao.jaxb.Standard;
import com.quantumdata.sct.dao.jaxb.impl.ServiceImpl;
import com.quantumdata.sct.dao.jaxb.impl.ServicesTypeImpl;
import com.quantumdata.sct.dao.vo.CommandInvocationVO;
import com.quantumdata.sct.dao.vo.InputCapabilityVO;
import com.quantumdata.sct.dao.vo.OptionCapabilityVO;
import com.quantumdata.sct.dao.vo.ServiceVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServiceDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = null;

    public void readCallback() throws DAOException {
        try {
            Services services = (Services)this.daoObject;
            List list = services.getServices();
            Iterator iterator = list.iterator();
            this.daoCollection.clear();
            int n = 0;
            while (iterator.hasNext()) {
                ServicesTypeImpl.ServiceImpl serviceImpl = (ServicesTypeImpl.ServiceImpl)iterator.next();
                this.daoCollection.put(serviceImpl.getId(), new Integer(n));
                ++n;
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    protected IPersistable getValueObjectForKey(Object object) throws CreateException {
        IPersistable iPersistable = null;
        try {
            int n = (Integer)this.daoCollection.get(object);
            ServicesTypeImpl.ServiceImpl serviceImpl = (ServicesTypeImpl.ServiceImpl)((Services)this.daoObject).getServices().get(n);
            iPersistable = this.createPersistable(serviceImpl);
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            throw new CreateException("Unable to fetch Command for key = " + object.toString(), null, exception);
        }
        return iPersistable;
    }

    public IPersistable[] findByAll() throws Exception {
        int n = ((Services)this.daoObject).getServices().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            ServicesTypeImpl.ServiceImpl serviceImpl = (ServicesTypeImpl.ServiceImpl)((Services)this.daoObject).getServices().get(i);
            iPersistableArray[i] = this.createPersistable(serviceImpl);
        }
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof Standard) {
            Standard standard = (Standard)object;
            object2 = standard.getId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    public final IPersistable createPersistable(Object object) {
        ServiceVO serviceVO = null;
        try {
            if (object instanceof ServicesTypeImpl.ServiceImpl) {
                serviceVO = new ServiceVO();
                this.copyFrom((ServicesTypeImpl.ServiceImpl)object, serviceVO);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return serviceVO;
    }

    public final void update(IPersistable iPersistable) throws UpdateException {
        if (iPersistable instanceof InputCapabilityVO) {
            this.update((InputCapabilityVO)iPersistable);
        } else if (iPersistable instanceof OptionCapabilityVO) {
            this.update((OptionCapabilityVO)iPersistable);
        }
    }

    protected void updateObject(IPersistable iPersistable) {
        try {
            if (iPersistable instanceof InputCapabilityVO) {
                this.update((InputCapabilityVO)iPersistable);
            } else if (iPersistable instanceof OptionCapabilityVO) {
                this.update((OptionCapabilityVO)iPersistable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected final IPersistable findByPrimaryKey(String string) throws ReadException {
        IPersistable iPersistable = null;
        try {
            if (this.daoCollection.containsKey(string)) {
                Integer n = (Integer)this.daoCollection.get(string);
                Object e = ((Services)this.daoObject).getServices().get(n);
                iPersistable = this.createPersistable(e);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ReadException(exception.getMessage());
        }
        return iPersistable;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                int n = (Integer)this.daoCollection.get(object);
                ((Services)this.daoObject).getServices().remove(n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void add(IPersistable iPersistable) throws CreateException {
        try {
            if (iPersistable instanceof ServiceVO) {
                ServicesTypeImpl.ServiceImpl serviceImpl = this.create(iPersistable);
                ((Services)this.daoObject).getServices().add(serviceImpl);
                this.flush();
                this.readCallback();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CreateException("Unable to insert VO object", null, exception);
        }
    }

    public ServicesTypeImpl.ServiceImpl create(IPersistable iPersistable) throws Exception {
        ServicesTypeImpl.ServiceImpl serviceImpl = null;
        if (!(iPersistable instanceof ServiceVO)) {
            throw new Exception("Invalid Value Object");
        }
        serviceImpl = (ServicesTypeImpl.ServiceImpl)this.factory.createServicesTypeService();
        this.copyTo(serviceImpl, (ServiceVO)iPersistable);
        return serviceImpl;
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            if (iPersistable instanceof ServiceVO) {
                ServicesTypeImpl.ServiceImpl serviceImpl = this.create(iPersistable);
                ((Services)this.daoObject).getServices().set(n, serviceImpl);
                this.flush();
                this.readCallback();
            }
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            throw new CreateException("Unable to insert VO object", null, exception);
        }
    }

    public void copyTo(ServicesTypeImpl.ServiceImpl serviceImpl, ServiceVO serviceVO) throws Exception {
        try {
            serviceImpl.setId((String)serviceVO.getId());
            serviceImpl.setLastUpdateTime(serviceVO.getLastUpdate());
            ArrayList arrayList = serviceVO.getCommandInvocations();
            Iterator iterator = arrayList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                CommandInvocationVO commandInvocationVO = (CommandInvocationVO)iterator.next();
                ServiceImpl.CommandInvocationImpl commandInvocationImpl = (ServiceImpl.CommandInvocationImpl)this.factory.createServiceCommandInvocation();
                commandInvocationImpl.setCommandId(commandInvocationVO.getCommandId());
                Iterator iterator2 = commandInvocationVO.getParmMaps().iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    CommandInvocationVO.ParameterMappingVO parameterMappingVO = (CommandInvocationVO.ParameterMappingVO)iterator.next();
                    CommandInvocation.CommandParameterMapping commandParameterMapping = this.factory.createCommandInvocationCommandParameterMapping();
                    commandParameterMapping.setName(parameterMappingVO.getServiceParameterName());
                    commandParameterMapping.setCmdParmName(parameterMappingVO.getCommandParameterName());
                    commandParameterMapping.setCmdParmValue(parameterMappingVO.getCommandParameterValue());
                    commandInvocationImpl.setParameterMapping(n2, commandParameterMapping);
                    ++n2;
                }
                serviceImpl.setCommands(n, commandInvocationImpl);
                ++n;
            }
        }
        catch (Exception exception) {
            this.log("Error in Copying To value object");
        }
    }

    public void copyFrom(ServicesTypeImpl.ServiceImpl serviceImpl, ServiceVO serviceVO) throws Exception {
        serviceVO.setId(serviceImpl.getId());
        serviceVO.setLastUpdate(serviceVO.getLastUpdate());
        int n = serviceImpl.getCommandsLength();
        for (int i = 0; i < n; ++i) {
            Service.CommandInvocation commandInvocation = serviceImpl.getCommands(i);
            CommandInvocationVO commandInvocationVO = new CommandInvocationVO(commandInvocation.getCommandId());
            int n2 = commandInvocation.getParameterMappingLength();
            for (int j = 0; j < n2; ++j) {
                CommandInvocation.CommandParameterMapping commandParameterMapping = commandInvocation.getParameterMapping(j);
                CommandInvocationVO.ParameterMappingVO parameterMappingVO = commandInvocationVO.createParameterVO(commandParameterMapping.getName(), commandParameterMapping.getCmdParmName(), commandParameterMapping.getCmdParmValue());
                commandInvocationVO.addParmMap(parameterMappingVO);
            }
            serviceVO.add(commandInvocationVO);
        }
    }
}

